<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 16/03/2017
 * Time: 14:16
 */
namespace Bloom\LaravelBrevo;

use Bloom\LaravelBrevo\Facades\BrevoMailTransport;
use Illuminate\Support\ServiceProvider;
use Brevo\Client\Configuration;


class BrevoServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
    /**
     * Register bindings in the container.
     *
     * @return void
     */
    public function register()
    {

        $this->app->singleton('sms', function($app) {
            return new BrevoSmsTransport(
                Configuration::getDefaultConfiguration()
                    ->setApiKey(
                        'api-key',
                        config('services.brevo.key')
                    ),
                config('services.brevo.tag')
            );
        });
    }
}
