<?php

namespace Bloom\LaravelBrevo;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\View;

class NotificationMail extends Mailable
{
    use Queueable, SerializesModels;

    const DEFAULT_VIEW = 'mails.mail';
    const DEFAULT_FROM_EMAIL = 'support@bloom-multimedia.fr';
    const DEFAULT_FROM_NAME = 'Support Bloom';
    const DEFAULT_TO_EMAIL = 'support@bloom-multimedia.fr';
    const DEFAULT_TO_NAME = 'support';
    const DEFAULT_SUBJECT = 'Mail de test';

    protected $data;
    protected $view_path = self::DEFAULT_VIEW;
    protected $from_email =self::DEFAULT_FROM_EMAIL;
    protected $from_name =self::DEFAULT_FROM_NAME;
    public $to_email = self::DEFAULT_TO_EMAIL;
    public $to_name = self::DEFAULT_TO_NAME;
    public $subject  = self::DEFAULT_SUBJECT;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data, $to)
    {
        $this->data = $data;

        //set view
        if(isset($this->data['view']) && !empty($this->data['view'])){
            if(View::exists($this->data['view'])){
                $this->view_path = $this->data['view'];
            }
            else{
                Log::error( 'Erreur : La vue '.$this->data['view'].' n\'existe pas.' );
                throw new \Exception('La vue '.$this->data['view'].' n\'existe pas.');
            }
        }

        //set from email
        if(isset($this->data['from_email']) && !empty($this->data['from_email'])){
            $this->from_email = $this->data['from_email'];
        }

        //set from name
        if(isset($this->data['from_name']) && !empty($this->data['from_name'])){
            $this->from_name = $this->data['from_name'];
        }

        //set to
        if(!empty($to)){
            $this->to_email = $to['email'];
            $this->to_name = $to['name'];
        }
        else {
            $this->to_email= config('services.brevo.to.address');
            $this->to_name =config('services.brevo.to.name');
        }
        if(env('APP_ENV', 'prod') !== 'prod'){
            $this->to_email= config('services.brevo.to.address');
            $this->to_name =config('services.brevo.to.name');
        }

        //set subject
        if(isset($this->data['subject']) && !empty($this->data['subject'])){
            $this->subject = $this->data['subject'];
        }
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view($this->view_path)
            ->from($this->from_email, $this->from_name)
            ->subject($this->subject)
            ->to($this->to_email, $this->to_name);
    }
}
