<?php

namespace Bloom\LaravelBrevo\Controllers;
use App\Http\Controllers\Controller;
use Bloom\LaravelBrevo\Facades\Sms;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;


class ApiController extends Controller
{
    public function __construct()
    {
        //
    }
    public function sendMails(Request $request){
        $data = $request->all();

        $recipients= $data['to'];
        $erreurs = [];

        if(!empty($data['to']) && !is_array($data['to'])){
            $recipients = [$data['to']];
        }
        foreach ($recipients as $recipient){
            try{
                if(empty($recipient['email'])){
                    throw new \Exception( 'Le format des destinataires n\'est pas correct. format attendu : [ "email"=>"support@bloom-multimedia.fr","name"=> "support"]. params : '.json_encode($recipient));
                }

                \Mail::send(new \Bloom\LaravelBrevo\NotificationMail($request->all(), $recipient));
                Log::info( 'Email sent to '.$recipient['email'].' at ' . now(). " : ".json_encode($request->all()));
            }
            catch(\Exception $e ){
                $erreurs[] = $e->getMessage();
                Log::error( 'Erreur : '. $e->getMessage() );
                continue;
            }
        }
        if(count($erreurs)>0){
            return response()->json(['message'=>'errors', 'status'=>500, 'errors'=> $erreurs]);
        }
        return response()->json(['message'=>'success', 'status'=>200]);
    }

    public function sendSMS(Request $request){

        $request->validate(
            [
                'from' => 'required',
                'text' => 'required',
                'tag' => 'required',
            ]
        );
        $data = $request->all();

        $from = substr(preg_replace("/[^A-Za-z0-9]/", '', $data['from']), 0, 11);
        $to =preg_replace("/^0/", '+33', $data['to']);
         try {
            if (SMS::send($to, $data['text'], $from, 'fr_FR', $data['tag'])) {
                return true;
            }
            Log::ALERT('SMS Notifier : unsucess', ['data' => $data]);

            return false;
        } catch (Exception $e) {
            Log::ALERT($e->getMessage(), ['data' => $data]);
        }

        return false;
    }
}
