<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 11/07/18
 * Time: 11:24
 */

namespace Bloom\HondaTemplate;


use Twig_Environment;
use Twig_Loader_Filesystem;

class Generator
{
    protected $twig;
    protected $loader;

    public function __construct($path, $cache)
    {
        $env = env('APP_ENV');
        $this->loader = new Twig_Loader_Filesystem($path);
        if ($env === 'prod' || $env === 'production') {
            $this->twig = new Twig_Environment($this->loader, array(
                'cache' => $cache,
            ));
        }
    }

    public function generate($division, $content)
    {
        try {
            $template = $this->twig->load($division . '/layout');
            return $template->render(['content' => $content]);
        } catch (\Twig_Error_Loader $e) {
        } catch (\Twig_Error_Runtime $e) {
        } catch (\Twig_Error_Syntax $e) {
        }

        return "";
    }

    public function auto($content)
    {
        return $this->generate('auto', $content);
    }

    public function moto($content)
    {
        return $this->generate('moto', $content);
    }
}