<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 11/07/18
 * Time: 11:14
 */

namespace Bloom\HondaTemplate;

use Illuminate\Support\ServiceProvider;
use Twig\TwigFunction;
use TwigBridge\Facade\Twig;

class HondaTemplateServicesProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->register(\TwigBridge\ServiceProvider::class);
        $this->app->alias('Twig', \TwigBridge\Facade\Twig::class);
    }

    public function boot()
    {
        Twig::addFunction(new TwigFunction('service_division', function ($division) {
            switch (env('APP_ENV')) {
                case 'production':
                    // no break;
                case 'prod':
                    return "https://services-$division.honda.fr";
                case 'preprod':
                    return "https://services-$division.preprod.kora.pro";
                case 'development':
                    // no break;
                default:
                    return "http://services-$division.benjamin.dev.justiceleague.bloom";
            }
        }));
        $this->loadViewsFrom(dirname(__DIR__) . '/ressources/views', 'HondaTemplate');
        $this->publishes([
            dirname(__DIR__) . '/ressources/assets/css'   => public_path('template/styles'),
            dirname(__DIR__) . '/ressources/assets/fonts' => public_path('template/fonts'),
            dirname(__DIR__) . '/ressources/assets/js'    => public_path('template/scripts')
        ], 'public');
    }
}