<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 11/07/18
 * Time: 11:24
 */

namespace Bloom\HondaTemplate;


use Twig\TwigFunction;
use Twig_Environment;

class Generator
{
    protected $twig;

    public function __construct($path, $cache)
    {
        $loader = new Loader($path);
        $loader->addPath(dirname(__DIR__) . '/ressources/views', 'HondaTemplate');
        $this->twig = new Twig_Environment($loader, array(
            'cache' => $cache,
        ));
        $this->twig->addFunction('service_division', new TwigFunction('service_division', function ($division) {
            switch (env('APP_ENV')) {
                case 'production':
                    // no break;
                case 'prod':
                    return "https://services-$division.honda.fr";
                case 'preprod':
                    return "https://services-$division.preprod.kora.pro";
                case 'development':
                    // no break;
                default:
                    return "http://services-$division.benjamin.dev.justiceleague.bloom";
            }
        }));
    }

    public function generate($division, $content)
    {
        try {
            $template = $this->twig->load($division . '/layout.twig');

            return $template->render(['content' => $content]);
        } catch (\Twig_Error_Loader $e) {
            error_log($e->getMessage());
        } catch (\Twig_Error_Runtime $e) {
            error_log($e->getMessage());
        } catch (\Twig_Error_Syntax $e) {
            error_log($e->getMessage());
        }

        return "";
    }

    public function auto($content)
    {
        return $this->generate('auto', $content);
    }

    public function moto($content)
    {
        return $this->generate('moto', $content);
    }
}