<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 24/02/20
 * Time: 12:04
 */

namespace Bloom\HondaTemplate;

use Twig\Error\LoaderError;
use Twig\Loader\FilesystemLoader;

class Loader extends FilesystemLoader
{
    protected function parseName($name, $default = self::MAIN_NAMESPACE)
    {
        if ((isset($name[0]) && '@' == $name[0]) || str_contains($name, '::')) {
            if (strpos($name, '::') === false) {
                if (false === $pos = strpos($name, '/')) {
                    throw new LoaderError(sprintf('Malformed namespaced template name "%s" (expecting "@namespace/template_name").', $name));
                }

                $namespace = substr($name, 1, $pos - 1);
                $shortname = substr($name, $pos + 1);
            } else {
                list($namespace, $shortname) = explode('::', $name);
            }

            return [$namespace, $shortname];
        }

        return [$default, $name];
    }
}