<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 13/01/2016
 * Time: 14:33
 */

namespace Bloom\Entis\Configuration;


/**
 * Class Configuration
 * @package Bloom\Entis\Configuration
 */
class Configuration extends \Bloom\Configuration
{

    /**
     *
     */
    const M1C = 2;
    /**
     *
     */
    const MF = 4;
    /**
     *
     */
    const MP = 8;

    /**
     * @var int Could be only : m1c / mf / mp
     */
    protected $structure;

    /**
     * @var string
     */
    protected $env;
    /**
     * @var string
     */
    protected $entity;
    /**
     * @var string
     */
    protected $dev;

    /**
     * Get the current developer if we are in dev mode
     * @return string
     */
    public static function getDev()
    {
        return static::getInstance()->dev;
    }

    /**
     * @return string
     */
    public static function getEntity()
    {
        return static::getInstance()->entity;
    }

    /**
     * @param string $entity
     */
    public function setEntity($entity)
    {
        $this->entity = $entity;
    }

    /**
     * @return string
     */
    public static function getEnv()
    {
        return static::getInstance()->env;
    }

    /**
     * @param string $env
     */
    public function setEnv($env)
    {
        $this->env = $env;
    }

    /**
     * Defines conf path and other constant
     */
    public static function Defines()
    {
        if (!defined('CONF_PATH')) {
            define('CONF_PATH', dirname(__DIR__) . '/conf');
        }
    }

    /**
     * load the configuration file dependings on the REQUEST_URI
     */
    public static function load()
    {
        $instance = static::getInstance();
        if (preg_match('/(?P<entity>\w+)\.(entis|entis-cms)\.(?P<env>all|(?P<dev>\w+).dev).bertaga.bloom/', $_SERVER['REQUEST_URI'], $matches)) {
            $instance->setEnv($matches['env']);
            $instance->setEntity($matches['entity']);
            if ($instance->env === 'all') {
                $instance->dev = 'all';
            } else {
                $instance->dev = $matches['dev'];
                $instance->setEnv(str_replace($instance->dev . '.', '', $instance->env));
            }
        } else {
            //todo : Checker la prod ou preprod web ici
        }
        $instance->SetFile(static::getEntity());
    }

    /**
     * Set and load a particuliar file in the CONF_PATH
     * @param $file
     * @return $this
     */
    public function SetFile($file)
    {
        return parent::SetFile(CONF_PATH . '/' . $file);
    }

    /**
     * @return $this
     */
    public function setM1C()
    {
        $this->structure = self::M1C;
        return $this;
    }

    /**
     * @return bool
     */
    public function isM1C()
    {
        return $this->structure === self::M1C;
    }

    /**
     * @return $this
     */
    public function setMF()
    {
        $this->structure = self::MF;
        return $this;
    }

    /**
     * @return bool
     */
    public function isMF()
    {
        return $this->structure === self::MF;
    }

    /**
     * @return bool
     */
    public function isMP()
    {
        return $this->structure === self::MP;
    }

    /**
     * Set the structure to MP
     * @return $this
     */
    public function setMP()
    {
        $this->structure = self::MP;
        return $this;
    }

    /**
     * Get a param
     * @param $param
     * @param string $section
     * @return null
     */
    public static function get($param, $section = '')
    {
        if ($section === '' && static::getDev() !== 'all') {
            try {
                return parent::get($param, static::getDev());
            } catch (\Exception $e) {
                return parent::get($param, static::getEnv());
            }
        }
        return parent::get($param, $section ?: strtoupper(static::getEnv()));
    }

    /**
     * load the conf file + override in /dev
     */
    protected function loadConf()
    {
        parent::loadConf();
        if ($this->dev && file_exists(CONF_PATH . '/dev/' . $this->entity . '.ini')) {
            $conf = parse_ini_file(CONF_PATH . '/dev/' . $this->entity . '.ini', true);
            $this->conf = array_merge($this->conf, $conf);
        }
    }
}