<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 13/01/2016
 * Time: 14:33
 */

namespace Bloom\Entis\Configuration;


/**
 * Class Configuration
 * @package Bloom\Entis\Configuration
 */
class Configuration extends \Bloom\Configuration
{

    /**
     *
     */
    const STRUCTURE_M1C = 2;
    /**
     *
     */
    const STRUCTURE_MF = 4;
    /**
     *
     */
    const STRUCTURE_MP = 8;

    const TYPE_FRONT = 2;
    const TYPE_BACK = 4;

    /**
     * @var int Could be only : m1c / mf / mp
     */
    protected $structure;

    /**
     * @var string
     */
    protected $env;
    /**
     * @var string
     */
    protected $entity;
    /**
     * @var string
     */
    protected $dev;
    /**
     * @var int
     */
    protected $type;

    /**
     * Return the current type
     * @return int
     */
    public static function getType()
    {
        return static::getInstance()->type;
    }

    /**
     * Are we in front-office
     * @return bool
     */
    public static function isFront()
    {
        return static::getType() === static::TYPE_FRONT;
    }

    /**
     * Are we in back-office.
     * @return bool
     */
    public static function isBack()
    {
        return static::getType() === static::TYPE_BACK;
    }

    /**
     * Get the current developer if we are in dev mode
     * @return string
     */
    public static function getDev()
    {
        return static::getInstance()->dev;
    }

    /**
     * @return string
     */
    public static function getEntity()
    {
        return static::getInstance()->entity;
    }

    /**
     * @param string $entity
     */
    public function setEntity($entity)
    {
        $this->entity = $entity;
    }

    /**
     * @return string
     */
    public static function getEnv()
    {
        return static::getInstance()->env;
    }

    /**
     * @param string $env
     */
    public function setEnv($env)
    {
        $this->env = $env;
    }

    /**
     * Defines conf path and other constant
     */
    public static function Defines()
    {
        if (!defined('CONF_PATH')) {
            define('CONF_PATH', dirname(__DIR__) . '/conf');
        }
    }

    /**
     * load the configuration file dependings on the HTTP_HOST
     */
    public static function load()
    {
        $instance = static::getInstance();
        if (preg_match('/(?P<entity>\w+)\.(?P<type>entis-ms-(?<strucuture>\w+)|entis-cms|entis)\.(?P<env>all|(?P<dev>\w+).dev).bertaga.bloom(\.pro)?/', $_SERVER['HTTP_HOST'], $matches)) {
            $instance->setEnv($matches['env']);
            $instance->setEntity($matches['entity']);
            if ($instance->env === 'all') {
                $instance->dev = 'all';
            } else {
                $instance->dev = $matches['dev'];
                $instance->setEnv(str_replace($instance->dev . '.', '', $instance->env));
            }
            $instance->type = ($matches['type'] === 'entis' ? static::TYPE_FRONT : static::TYPE_BACK);
        } else {
            if (preg_match('/(?P<entity>\w+)\.(?P<type>entis-ms-(?<strucuture>\w+)|entis-cms|entis)\.(?P<env>preprod.)?bloom.pro/', $_SERVER['MAINVHOST'], $matches)) {
                $instance->setEnv(array_key_exists('env',$matches) && $matches['env'] === 'preprod.' ? 'PREPROD' : 'PROD');
                $instance->type = ($matches['type'] === 'entis-cms' ? static::TYPE_BACK : static::TYPE_FRONT);
                $instance->setEntity($matches['entity']);
            }
        }
        if (array_key_exists('structure', $matches)) {
            switch ($matches['strucuture']) {
                case 'mf':
                    $instance->setMF();
                    break;
                case 'm1c':
                    $instance->setM1C();
                    break;
                case 'mp':
                    $instance->setMP();
                    break;
                default:
                    break;
            }
        }
        $instance->SetFile(static::getEntity());
    }

    /**
     * Set and load a particuliar file in the CONF_PATH
     * @param $file
     * @return $this
     */
    public function SetFile($file)
    {
        return parent::SetFile(CONF_PATH . '/' . $file);
    }

    /**
     * @return $this
     */
    public function setM1C()
    {
        $this->structure = static::STRUCTURE_M1C;
        return $this;
    }

    /**
     * @return bool
     */
    public function isM1C()
    {
        return $this->structure === static::STRUCTURE_M1C;
    }

    /**
     * @return $this
     */
    public function setMF()
    {
        $this->structure = static::STRUCTURE_MF;
        return $this;
    }

    /**
     * @return bool
     */
    public function isMF()
    {
        return $this->structure === static::STRUCTURE_MF;
    }

    /**
     * @return bool
     */
    public function isMP()
    {
        return $this->structure === static::STRUCTURE_MP;
    }

    /**
     * Set the structure to MP
     * @return $this
     */
    public function setMP()
    {
        $this->structure = static::STRUCTURE_MP;
        return $this;
    }

    /**
     * Get a param
     * @param $param
     * @param string $section
     * @return null
     */
    public static function get($param, $section = '')
    {
        if(static::getEnv() === 'PROD' || static::getEnv() === 'PREPROD') {
            return parent::get($param, $section ?: strtoupper(static::getEnv()));
        }
        if ($section === '' && static::getDev() !== 'all') {
            if (array_key_exists($param, static::$_instance->conf[static::getDev()])) {
                return parent::get($param, static::getDev());
            }
            return parent::get($param, 'ALL');
        }
        return parent::get($param, $section ?: strtoupper(static::getEnv()));
    }

    /**
     * load the conf file + override in /dev
     */
    protected function loadConf()
    {
        parent::loadConf();
        if ($this->dev && file_exists(CONF_PATH . '/dev/' . $this->entity . '.ini')) {
            $conf = parse_ini_file(CONF_PATH . '/dev/' . $this->entity . '.ini', true);
            $this->conf = array_merge($this->conf, $conf);
        }
    }
}