<?php

namespace Bloom\Entis\Configuration;

/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 13/01/2016
 * Time: 14:37
 */
class ConfigurationTest extends \PHPUnit_Framework_TestCase
{


    public function conf_provider()
    {
        return [
            ['test1', 'SECTION1', 'foo','bar'],
            ['test2', 'SECTION1', 'bar','foo']
        ];
    }

    public function autoload_provider()
    {
        return [
            ['test1.entis.all.bertaga.bloom','test1', 'all'],
            ['test2.entis.all.bertaga.bloom','test2', 'all'],
            ['test2.entis.loic.dev.bertaga.bloom','test2', 'dev']
        ];
    }

    public function databaseCheck_provide()
    {
        return [
            ['test1.entis.all.bertaga.bloom','test1', 'all', 'all_entis-ms-m1c_test1'],
            ['test2.entis.all.bertaga.bloom','test2', 'all', 'all_entis-ms-m1c_test2'],
            ['test2.entis.loic.dev.bertaga.bloom','test2', 'dev', 'd_loic_entis-ms-m1c_test2']
        ];
    }

    /**
     * @beforeClass
     */
    public static function beforeClass()
    {
        Configuration::Defines();
    }

    /**
     * @dataProvider conf_provider
     */
    public function test_load_conf_file_in_conf_path($file, $section , $param, $expected)
    {

        $conf = Configuration::getInstance();

        $conf->SetFile($file);

        static::assertEquals($expected, Configuration::get($param,$section), 'Unable to load the configuration file correctly');
    }

    /**
     * @dataProvider autoload_provider
     */
    public function test_autoload_configuration_file($baseUrl, $entity, $env)
    {
        $_SERVER['HTTP_HOST'] = $baseUrl;
        Configuration::load();

        static::assertEquals(Configuration::getEnv(), $env, 'Do not load the good environment');
        static::assertEquals(Configuration::getEntity(), $entity, 'Do not load the good entity');
    }

    /**
     * @param $baseUrl
     * @param $entity
     * @param $env
     * @param $database
     * @depends test_autoload_configuration_file
     * @dataProvider databaseCheck_provide
     */
    public function test_autoload_correct_configuration($baseUrl, $entity, $env, $database)
    {
        $_SERVER['HTTP_HOST'] = $baseUrl;
        Configuration::load();

        static::assertEquals($database, Configuration::get('dbname'), 'Invalid database format');
    }


    public function test_surcharge_if_empty()
    {
        $_SERVER['HTTP_HOST'] = 'test2.entis.loic.dev.bertaga.bloom';
        Configuration::load();

        static::assertEquals('', Configuration::get('host'));
    }

    public function test_test()
    {
        $_SERVER['HTTP_HOST'] = 'www.mutuelledefranceunie.fr';
        $_SERVER['MAINVHOST'] = 'mfu.entis-ms-m1c.bloom.pro';
        Configuration::load();
        var_dump(Configuration::getInstance());
    }
}
