# Configuration Loader Entis Minisite



## Installation

Ajouter les lignes suivantes dans votre composer.json :

```
#!json
"require": {
    "bloom/entis-ms-conf-loader" : "*"
}
```

Puis faite un :

```
#!bash

composer install
# ou
composer update
```

Ou bien faite :

```
#!bash

composer require bloom/entis-ms-conf-loader
```
## Utilisation

Example d'utilisation en php :

```
#!php
require_once 'vendor/autoload.php';
define('CONF_PATH', 'monCheminVersLaConfiguration');

use Bloom\Entis\Configuration\Configuration;    # Permet d'utilisé le nom court de la classe

Configuration::load();                          # Charge la configuration automatiquement en fonction de l'url


$host = Configuration::get('host');             # Récupere un paramètre définis dans le fichier de configuration de l'entité en cours
$user = Configuration::get('user');
$whatever = Configuration::get('whatever');

$env = Configuration::getEnv();                 # Récupere l'environement en cours
$entite = Configuration::getEntity();           # Récupere l'entité en cours

$All_host = Configuration::get('host', 'ALL');  # Force la récupération d'un paramétre dans une séction spécifique du fichier de configuration

if(Configuration::isFront()) {
    // Front office stuff here
}

if(Configuration::isBack()) {
    // Back office stuff here
}
```

### Configuration Rules

- Les fichiers de configuration doivent tous être stocké dans le même dossier.
- Les fichiers de configuration doivent avoir un minimum de 3 séction :
    - ALL
    - PREPROD
    - PROD
- Les surcharge de ces fichiers doivent être stocké dans le dossier *dev* au même emplacement que les fichiers de configuration
- Les surcharge ce définisent comme les fichier de configuration normal à l'exception faite que la séction doit porté le même nom que le développeur dans l'url *(ex: stephanie, loic, benjamin ...)* en minuscule
- Les vhost de prod/preprod doivent avoir comme ServerName le nom composé suivant : *entité*.entis-ms-*structure*.bloom.pro et *entité*.entis-ms-*structure*.preprod.bloom.pro pour la preprod.