<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 04/04/2016
 * Time: 14:58
 */

namespace Bloom\Entis\Api\Model\Iterator;


class Models extends \ArrayIterator
{
    /**
     * @param bool $single
     * @param array $exclude
     * @return $this
     */
    public function filter($single = false, Array $exclude = []) {
        foreach($this as $model) {
            $model->cleanBuild();
            $model->filter($single, $exclude);
        }
        return $this;
    }

    public function withFilter(callable $callable) {
        $new = new static();
        foreach($this as $k=>$model) {
            if($callable($model)) {
                $new[] = $model;
            }
        }
        return new static((array)$new->filter());
    }
}