<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 06/01/2016
 * Time: 10:26
 */

namespace Bloom\Entis\Api\Model;
use Unirest\Request;


/**
 * Class Theme
 * @package Bloom\Entis\Api\Model
 */
class Theme extends Model
{
    /**
     * @var array
     */
    protected static $exclude_all =  ['rang', 'type'];
    /**
     * @var array
     */
    protected static $exclude_single = ['rang', 'type'];

    /**
     * @var string
     */
    public $libelle;
    /**
     * @var string
     */
    public $slug;
    /**
     * @var int
     */
    public $rang;

    public function cleanBuild()
    {
        parent::cleanBuild();
        $this->rang = (int) $this->rang;
    }

    public function canRetrieve(Entite $entite)
    {
        $response = Request::get(static::$api.'/admin/rules/themes/'.$this->id,
            array(
                'Accept' => 'application/json',
                'X-Entis-Key' => $entite->cle,
                'Content-Type' => 'application/json'
            )
        );
        return !$response->body->exclude;
    }
}