<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 06/01/2016
 * Time: 10:26
 */

namespace Bloom\Entis\Api\Model;
use Unirest\Request;


/**
 * Class Cible
 * @package Bloom\Entis\Api\Model
 */
class Cible extends Model
{
    /**
     * @var array
     */
    protected static $exclude_all =  ['rang', 'type'];
    /**
     * @var array
     */
    protected static $exclude_single = ['rang', 'type'];

    /**
     * @var string
     */
    public $libelle;
    /**
     * @var string
     */
    public $slug;
    /**
     * @var int
     */
    public $rang;
    /**
     * @var int
     */
    public $type;

    public function cleanBuild()
    {
        parent::cleanBuild();
        $this->rang = (int) $this->rang;
        $this->type = (int) $this->type;
    }

    public function canRetrieve(Entite $entite)
    {
        $response = Request::get(static::$api.'/admin/rules/cibles/'.$this->id,
            array(
                'Accept' => 'application/json',
                'X-Entis-Key' => $entite->cle,
                'Content-Type' => 'application/json'
            )
        );
        return
            !$response->body->exclude;
    }

}