<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 06/01/2016
 * Time: 10:15
 */

namespace Bloom\Entis\Api\Model;



/**
 * Class FicheProduct
 * @package Bloom\Entis\Api\Model
 */
class FicheProduct extends Model
{
    /**
     * @var array
     */
    protected static $exclude_all = [
        'produit_id', 'cible_id', 'theme_id', 'offre_id', 'contenu1', 'contenu2', 'contenu3', 'contenu4'
        , 'metaDescription', 'metaTitle', 'formb3'
    ];
    /**
     * @var array
     */
    protected static $exclude_single = [
        'produit_id', 'cible_id', 'theme_id', 'offre_id', 'formb3'
    ];

    /**
     * @var string
     */
    protected static $table = 'fiche_produit';

    /**
     * @var array
     */
    protected static $relationship = [
        'produit' => Product::class,
        'theme' => Theme::class,
        'cible' => Cible::class,
        'offre' => Offre::class
    ];

    public static $getChildren = false;

    /**
     * @var FicheProduct[]
     */
    public $children;

    /**
     * @var string
     */
    public $titre;
    /**
     * @var string
     */
    public $slug;
    /**
     * @var string
     */
    public $soustitre;
    /**
     * @var int
     */
    public $etat;
    /**
     * @var int
     */
    public $rang;
    /**
     * @var string
     */
    public $accroche;
    /**
     * @var Product
     */
    public $produit;
    /**
     * @var Theme
     */
    public $theme;
    /**
     * @var Offre
     */
    public $offre;
    /**
     * @var string
     */
    public $contenu1;
    /**
     * @var string
     */
    public $contenu2;
    /**
     * @var string
     */
    public $contenu3;
    /**
     * @var string
     */
    public $contenu4;
    /**
     * @var string
     */
    public $metaDescription;
    /**
     * @var string
     */
    public $metaTitle;
    /**
     * @var Cible
     */
    public $cible;

    public $formb3;

    /**
     * @param array $where
     * @param null $order
     * @return FicheProduct
     */
    public static function getItem(array $where = [], $order = null)
    {
        /**
         * @var Agence $item
         */
        return parent::getItem(array_merge($where,[['column'=>'etat','operator'=>'=','value'=>1]]), $order);
    }

    /**
     * @param array $where
     * @param null $order
     * @return FicheProduct[]
     */
    public static function getItems(array $where = [], $order = null)
    {
        return parent::getItems(array_merge($where,[['column'=>'etat','operator'=>'=','value'=>1]]), $order);
    }


    public function cleanBuild()
    {
        parent::cleanBuild();
        $this->rang = (int) $this->rang;
        $this->etat = (int) $this->etat;
        if(static::$getChildren) {
            $sth = static::$db->select(['fiche_produit_target'])->from('fiche_to_fiche')->where('fiche_produit_source','=',$this->id)->execute()->fetchAll(\PDO::FETCH_COLUMN);
            if(count($sth) > 0) {
                self::$getChildren = false;
                $this->children = static::getItems([
                    [
                        'column'=>'id',
                        'operator'=>'IN',
                        'value'=> $sth
                    ]
                ], null, ['id', 'titre', 'soustitre', 'slug', 'accroche', 'theme_id', 'cible_id', 'offre_id', 'produit_id']);
                self::$getChildren = true;
            } else {
                $this->children = [];
            }
        }
    }

    public function getForm() {
        if($this->formb3 === null) {
            return '';
        }

        return file_get_contents(TEMPLATE_PATH.'/'.$this->formb3);
    }
}