<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 04/04/2016
 * Time: 14:58
 */

namespace Bloom\Entis\Api\Model\Iterator;


class Models extends \ArrayIterator
{
    /**
     * @param bool $single
     * @param array $exclude
     * @return $this
     */
    public function filter($single = false, Array $exclude = []) {
        foreach($this as $model) {
            $model->filter();
        }
        return $this;
    }

    public function withFilter(callable $callable) {
        foreach($this->filter() as $k=>$model) {
            if(!$callable($model)) {
                unset($this[$k]);
            }
        }
        return $this;
    }
}