<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 06/01/2016
 * Time: 10:15
 */

namespace Bloom\Entis\Api\Model;
use Bloom\Entis\Api\Model\Iterator\Models;
use Bloom\Entis\Configuration\Configuration;
use PDO;
use Unirest\Request;
use Unirest\Response;


/**
 * Class FicheProduct
 * @package Bloom\Entis\Api\Model
 */
class FicheProduct extends Model
{
    /**
     * @var array
     */
    protected static $exclude_all = [
        'produit_id', 'cible_id', 'theme_id', 'offre_id', 'contenu1', 'contenu2', 'contenu3', 'contenu4'
        , 'metaDescription', 'metaTitle'
    ];
    /**
     * @var array
     */
    protected static $exclude_single = [
        'produit_id', 'cible_id', 'theme_id', 'offre_id'
    ];

    /**
     * @var string
     */
    protected static $table = 'fiche_produit';

    /**
     * @var array
     */
    protected static $relationship = [
        'produit' => Product::class,
        'theme' => Theme::class,
        'cible' => Cible::class,
        'offre' => Offre::class
    ];

    public static $getChildren = false;

    /**
     * @var FicheProduct[]
     */
    public $children;

    /**
     * @var string
     */
    public $titre;
    /**
     * @var string
     */
    public $slug;
    /**
     * @var string
     */
    public $soustitre;
    /**
     * @var int
     */
    public $etat;
    /**
     * @var int
     */
    public $rang;
    /**
     * @var string
     */
    public $accroche;
    /**
     * @var Product
     */
    public $produit;
    /**
     * @var Theme
     */
    public $theme;
    /**
     * @var Offre
     */
    public $offre;
    /**
     * @var string
     */
    public $contenu1;
    /**
     * @var string
     */
    public $contenu2;
    /**
     * @var string
     */
    public $contenu3;
    /**
     * @var string
     */
    public $contenu4;
    /**
     * @var string
     */
    public $metaDescription;
    /**
     * @var string
     */
    public $metaTitle;
    /**
     * @var Cible
     */
    public $cible;

    public $formb3;

     public $type;

    /**
     * @param array $where
     * @param null $order
     * @return FicheProduct
     */
    public static function getItem(array $where = [], $order = null)
    {
        /**
         * @var Agence $item
         */
        return parent::getItem(array_merge($where,[['column'=>'etat','operator'=>'=','value'=>1]]), $order);
    }


    public static function getAllItem(array $where = [], $order = null)
    {
        /**
         * @var Agence $item
         */
        return parent::getItem($where, $order);
    }


    /**
     * @param array $where
     * @param null $order
     * @return Models
     */
    public static function getItems(array $where = [], $order = null)
    {
        return parent::getItems(array_merge($where,[['column'=>'etat','operator'=>'=','value'=>1]]), $order);
    }


    /**
     * @param array $where
     * @param null $order
     * @return Models
     * no filter on etat
     */
    public static function getAllItems(array $where = [], $order = null)
    {
        return parent::getItems($where, $order);
    } 

    public function cleanBuild()
    {
        parent::cleanBuild();
        $this->rang = (int) $this->rang;
        $this->etat = (int) $this->etat;
        if(static::$getChildren) {
            $sth = static::$db->select(['fiche_produit_target'])->from('fiche_to_fiche')->where('fiche_produit_source','=',$this->id)->execute()->fetchAll(\PDO::FETCH_COLUMN);
            if(count($sth) > 0) {
                self::$getChildren = false;
                $this->children = new Models(static::$db->query('SELECT f.*
FROM fiche_produit as f
INNER JOIN theme as t ON t.id=f.theme_id
INNER JOIN cible as c ON c.id=f.cible_id
WHERE
	f.etat = 1 AND f.id IN ('.implode(',',$sth).')
ORDER BY t.rang, c.rang ,f.rang')->fetchAll(\PDO::FETCH_CLASS, FicheProduct::class));
                self::$getChildren = true;
            } else {
                $this->children = [];
            }
        }
    }

    public function canRetrieve(Entite $entite)
    {
        if(Configuration::getEntity() === 'central') {
            $me = static::$db->select()->from('fiche_exlusion')->where('fiche_produit_id','=',$this->id)->where('entite_id','=',$entite->id)->execute()->rowCount() === 0;
        } else {
            $response = Request::get(static::$api.'/admin/rules/fiches/'.$this->id,
                array(
                    'Accept' => 'application/json',
                    'X-Entis-Key' => $entite->cle,
                    'Content-Type' => 'application/json'
                )
            );
            $me = !$response->body->exclude;
        }
        return
            $me &&
            $this->cible->canRetrieve($entite) &&
            $this->theme->canRetrieve($entite)
        ;
    }

    /**
     * @param int $id
     * @return FicheProduct
     * @throws \ErrorException
     */
    public static function getById($id)
    {
        if(Configuration::getEntity() === 'central') {
            return static::getItem([['column'=>'id','operator'=>'=','value'=>$id]]);
        }
        $key = Configuration::get('api_key');
        /**
         * @var Response $response
         */
        $response = Request::get(static::$api.'/fichesproduits/'.$id,
            array(
                'Accept' => 'application/json',
                'X-Entis-Key' => $key,
                'Content-Type' => 'application/json'
            )
        );
        if($response->code !== 200) {
            throw new \ErrorException('Request error');
        }
        $body = $response->body;
        $a = new static();
        foreach($body as $key => $value) {
            $a->{$key} = $value;
        }

        return $a;
    }

    public function getForm() {
        if($this->formb3 === null) {
            return '';
        }
        if(file_exists(TEMPLATE_PATH.'/'.$this->formb3)) {
            return file_get_contents(TEMPLATE_PATH.'/'.$this->formb3);
        }
        return '';
    }
}