<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 06/01/2016
 * Time: 10:26
 */

namespace Bloom\Entis\Api\Model;
use Bloom\Entis\Configuration\Configuration;
use Unirest\Request;


/**
 * Class Theme
 * @package Bloom\Entis\Api\Model
 */
class Theme extends Model
{
    /**
     * @var string
     */
    public $libelle;
    /**
     * @var string
     */
    public $slug;
    /**
     * @var int
     */
    public $rang;

    public function cleanBuild()
    {
        parent::cleanBuild();
        $this->rang = (int) $this->rang;
    }

    public function canRetrieve(Entite $entite)
    {
        if(Configuration::getEntity() === 'central') {
            $me = static::$db->select()->from('theme_exlusion')->where('theme_id','=',$this->id)->where('entite_id','=',$entite->id)->execute()->rowCount() === 0;
        } else {
            $response = Request::get(static::$api.'/admin/rules/themes/'.$this->id,
                array(
                    'Accept' => 'application/json',
                    'X-Entis-Key' => $entite->cle,
                    'Content-Type' => 'application/json'
                )
            );
            $me = !$response->body->exclude;
        }
        return $me;
    }
}