<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 05/04/2016
 * Time: 14:51
 */

namespace Bloom\Entis\Api\Middleware;


use Bloom\Entis\Api\Model\Entite;
use Slim\Http\Request;
use Slim\Http\Response;

class Auth
{
    /**
     * @var Entite
     */
    protected static $entity = false;
    /**
     * @var bool
     */
    protected static $_isJedi = false;

    /**
     * @return Entite
     */
    public static function currentEntity() {
        return static::$entity;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param callable $next
     * @return Response
     * @throws \RuntimeException
     */
    public static function basic(Request $request, Response $response, Callable $next)
    {
        $entite = static::getLoggedEntity($request);
        if(!$entite) {
            return $response->withJson([
                'message'=>'Unable to resolve key : '.$request->getHeader('x-entis-key')[0],
                'code'=>404
            ],404);
        }
        static::$entity = $entite;
        return $next($request, $response);
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param callable $next
     * @return mixed
     * @throws \RuntimeException
     */
    public static function jedi(Request $request, Response $response, Callable $next)
    {
        $entite = static::getLoggedEntity($request);
        if(!$entite) {
            $a = $request->getHeader('x-entis-key');
            if(count($a) > 0 && $a[0] === md5('jedi')) {
                static::$_isJedi = true;
            } else {
                return $response->withJson([
                    'message'=>'I don\'t know you, get out !',
                    'code'=>400
                ], 400);
            }
        } else {
            static::$entity = $entite;
        }
        return $next($request, $response);
    }

    /**
     * @return bool
     */
    public static function isJedi()
    {
        return static::$_isJedi;
    }

    /**
     * @return bool
     */
    public static function isEntite()
    {
        return static::$entity instanceof Entite;
    }

    public static function none(Request $request, Response $response, Callable $next)
    {
        return $next($request, $response);
    }

    /**
     * @param Request $request
     * @return Entite|false
     */
    protected static function getLoggedEntity(Request $request)
    {
        $a = $request->getHeader('x-entis-key');
        if(count($a) > 0 ) {
            $cle = $a[0];
        } else {
            $cle = null;
        }
        return Entite::getItem([['column'=>'cle','operator'=>'=','value'=> $cle]]);
    }

    public static function middleware($type) {
        return static::class.'::'.$type;
    }
}