<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 06/01/2016
 * Time: 10:26
 */

namespace Bloom\Entis\Api\Model;
use Bloom\Entis\Configuration\Configuration;
use Unirest\Request;


/**
 * Class Cible
 * @package Bloom\Entis\Api\Model
 */
class Cible extends Model
{
    /**
     * @var string
     */
    public $libelle;
    /**
     * @var string
     */
    public $slug;
    /**
     * @var int
     */
    public $rang;
    /**
     * @var int
     */
    public $type;

    public function cleanBuild()
    {
        parent::cleanBuild();
        $this->rang = (int) $this->rang;
        $this->type = (int) $this->type;
    }

    public function canRetrieve(Entite $entite)
    {
        if(Configuration::getEntity() === 'central') {
            $me = static::$db->select()->from('cible_exlusion')->where('cible_id','=',$this->id)->where('entite_id','=',$entite->id)->execute()->rowCount() === 0;
        } else {
            $response = Request::get(static::$api.'/admin/rules/cibles/'.$this->id,
                array(
                    'Accept' => 'application/json',
                    'X-Entis-Key' => $entite->cle,
                    'Content-Type' => 'application/json'
                )
            );
            $me = !$response->body->exclude;
        }
        return $me;
    }

}