<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 06/01/2016
 * Time: 10:26
 */

namespace Bloom\Entis\Api\Model;


/**
 * Class Offre
 * @package Bloom\Entis\Api\Model
 */
class Offre extends Model
{
    /**
     * @var string
     */
    public $titre;
    /**
     * @var string
     */
    public $description;
    /**
     * @var string
     */
    public $mention;
    /**
     * @var \DateTime
     */
    public $dateDebut;
    /**
     * @var \DateTime
     */
    public $dateFin;

    public function cleanBuild()
    {
        $zone = new \DateTimeZone('Europe/Paris');
        parent::cleanBuild();
        $this->dateDebut = new \DateTime($this->dateDebut, $zone);
        $this->dateFin = new \DateTime($this->dateFin, $zone);
    }
    /**
     * @param array $where
     * @param null $order
     * @return Offre
     */
    public static function getItem(array $where = [], $order = null)
    {
        /**
         * @var Agence $item
         */
        return parent::getItem(array_merge($where,[['column'=>'etat','operator'=>'=','value'=>1]]), $order);
    }

    /**
     * @param array $where
     * @param null $order
     * @return Offre[]
     */
    public static function getItems(array $where = [], $order = null)
    {
        return parent::getItems(array_merge($where,[['column'=>'etat','operator'=>'=','value'=>1]]), $order);
    }
}