<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 06/01/2016
 * Time: 14:12
 */

namespace Bloom\Entis\Api\Model;


/**
 * Class Agence
 * @package Bloom\Entis\Api\Model
 */
class Agence extends Model
{

    /**
     * @var string
     */
    public $nom;
    /**
     * @var string
     */
    public $slug;
    /**
     * @var string
     */
    public $metaDescription;
    /**
     * @var string
     */
    public $metaTitle;
    /**
     * @var int
     */
    public $entite_id;
    /**
     * @var Entite
     */
    public $entite;
    /**
     * @var string
     */
    public $texte;
    /**
     * @var string
     */
    public $adresse;
    /**
     * @var string
     */
    public $cp;
    /**
     * @var Departement
     */
    public $departement;
    /**
     * @var string
     */
    public $ville;
    /**
     * @var string
     */
    public $tel1;
    /**
     * @var string
     */
    public $fax;
    /**
     * @var string
     */
    public $email;
    /**
     * @var string
     */
    public $horaires;
    /**
     * @var string
     */
    public $etat;
    /**
     * @var double
     */
    public $lat;
    /**
     * @var double
     */
    public $lng;

    /**
     * @var array
     */
    protected static $exclude_all = [
        'entite_id', 'texte', 'fax', 'email', 'horaires', 'etat', 'metaDescription', 'metaTitle'
    ];

    /**
     * @var array
     */
    protected static $relationship = [
        'entite'=> Entite::class
    ];

    /**
     * @param array $where
     * @param null $order
     * @return Agence
     */
    public static function getItem(array $where = [], $order = null)
    {
        /**
         * @var Agence $item
         */
        return parent::getItem(array_merge($where,[['column'=>'etat','operator'=>'=','value'=>1]]), $order);
    }

    /**
     * @param array $where
     * @param null $order
     * @return Agence[]
     */
    public static function getItems(array $where = [], $order = null)
    {
        return parent::getItems(array_merge($where,[['column'=>'etat','operator'=>'=','value'=>1]]), $order);
    }

    public function cleanBuild()
    {
        parent::cleanBuild();
        $this->departement = Departement::getItem([
            [
                'column'=>'id',
                'operator'=>'=',
                'value'=> strpos($this->cp, '97') === 0?substr($this->cp, 0,3): substr($this->cp, 0 , 2)
            ]
        ]);
        $this->lat = (double) $this->lat;
        $this->lng = (double) $this->lng;
    }
}