<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 06/01/2016
 * Time: 10:17
 */

namespace Bloom\Entis\Api\Model;
use Slim\PDO\Database;
use Slim\PDO\Statement\SelectStatement;
use \Bloom\Entis\Api\Model\Iterator\Models as ModelIterator;

/**
 * Class Model
 * @package Bloom\Entis\Api\Model
 */
abstract class Model
{
    /**
     * The database driver
     * @var Database
     */
    static protected $db;
    /**
     * @var string
     */
    static protected $api;

    /**
     * The corresponding table in database
     * @var string
     */
    static protected $table;

    static protected $relationship = [];

    protected static $exclude_all = [];
    protected static $exclude_single = [];

    private $cleaned = false;

    /**
     * @var int
     */
    public $id;

    /**
     * Get items filter by the given where. Will automatically be cast in the current type.
     * So an array of entity will be returns
     * @param array $where Needle form -> [ ['column'=>'foo', 'operator'=>'=', 'value=>'bar'] ]
     * @param string|null $order
     * @param array $select
     * @return ModelIterator
     */
    public static function getItems(array $where  = [], $order = null, array $select = [])
    {
        $table = static::$table?:strtolower((new \ReflectionClass(static::class))->getShortName());
        $sth = static::$db
            ->select($select)
            ->from($table);
        if($order !== null){
            $sth->orderBy($order);
        }
        if(count($where) !== 0 ) {
            foreach ($where as $condition) {
                static::addWhere($sth, $condition);
            }
        }
        /**
         * @var Model[] $models
         */
        $models = $sth
            ->execute()
            ->fetchAll(\PDO::FETCH_CLASS, static::class);
        foreach ($models as $model) {
            $model->cleanBuild();
        }
        return new ModelIterator($models);
    }

    /**
     * @param array $where
     * @param null $order
     * @param array $exclude
     * @return string
     */
    public static function getItemsJson(array $where  = [], $order = null, array $exclude = []){
        $models = static::getItems($where, $order);
        $b = [];
        foreach ($models as $model) {
            $b[] = $model->toJSON($exclude, true);
        }
        return '['.implode(',',$b).']';
    }

    /**
     * Get items filter by the given where. Will automatically be cast in the current type.
     * So an array of entity will be returns
     * @param array $where Needle form -> [ ['column'=>'foo', 'operator'=>'=', 'value=>'bar'] ]
     * @param string|null $order
     * @param array $select
     * @return Model
     */
    public static function getItem(array $where  = [], $order = null, array $select = [])
    {
        $table = static::getTable();
        $sth = static::$db
            ->select($select)
            ->from($table);
        if($order !== null){
            $sth->orderBy($order);
        }
        if(count($where) !== 0 ) {
            foreach ($where as $condition) {
                static::addWhere($sth, $condition);
            }
        }
        $model = $sth
            ->execute()
            ->fetchObject(static::class);
        if($model === false){
            return false;
        }
        $model->cleanBuild();
        return $model;
    }

    protected static function addWhere(SelectStatement $statement, array $condition) {
            if(in_array($condition['operator'],['=','!=','<','>','<=','>='])) {
                $statement->where($condition['column'], $condition['operator'], $condition['value']);
            } else {
                switch ($condition['operator']) {
                    case 'LIKE' :
                        $statement->whereLike($condition['column'], $condition['value']);
                        break;
                    case 'NOT LIKE':
                        $statement->whereNotLike($condition['column'], $condition['value']);
                        break;
                    case 'IN':
                        $statement->whereIn($condition['column'], $condition['value']);
                        break;
                    case 'NOT IN':
                        $statement->whereNotIn($condition['column'], $condition['value']);
                        break;
                    default:
                        $statement->whereLike($condition['column'], $condition['value']);
                }
            }
    }

    public function cleanBuild(){
        if($this->cleaned) return;
        foreach (static::$relationship as $item=>$class) {
            $this->{$item} = $class::getItem(
                [
                    [
                        'column'=>'id',
                        'operator'=>'=',
                        'value'=>$this->{$item.'_id'}
                    ]
                ]
            );
        }
        $this->id = (int) $this->id;
        $this->cleaned = true;
    }

    public function filter($single,Array $exclude = []) {
        $exclude = array_merge($exclude, ($single?static::$exclude_all:static::$exclude_single));
        foreach ($exclude as $item) {
            $this->{$item} = null;
        }
        foreach ($this as $c=>$b) {
            if($b instanceof Model) {
                $this->{$c} = $b->filter(true, []);
            }
        }
        return $this;
    }

    public function __get($name){
        $this->cleanBuild();
        return $this->{$name};
    }

    /**
     * @param array $where
     * @param null $order
     * @param array $exclude
     * @return string
     */
    public static function getItemJson(array $where  = [], $order = null, array $exclude = [])
    {
        $item = static::getItem($where,$order);
        if($item) {
            return $item->toJSON($exclude);
        } else {
            return json_encode([
                'error'=>[
                    'code'=>404,
                    'message'=>'Item not found'
                ]
            ]);
        }
    }

    public function toJSON(array $exclude = [], $single = false) {
        $this->filter($single, $exclude);
        return json_encode($this);
    }

    /**
     * @param Database $database
     */
    public static function setDataBase(Database $database)
    {
        static::$db = $database;
    }

    public static function setApiUrl($uri)
    {
        static::$api =  preg_replace('/(\/)$/','', $uri);
    }

    /**
     * @return string
     */
    public static function getTable() {
        return  static::$table?:strtolower((new \ReflectionClass(static::class))->getShortName());
    }
}
