<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 08/06/18
 * Time: 11:11
 */

namespace Bloom\EcranSav\Http;

use Guzzle\Http\Client;
use Guzzle\Http\Message\Response;

class Api
{
    /**
     * Our config
     * @var array
     */
    protected $config;
    /**
     * Guzzle Client to make http call
     * @var Client
     */
    protected $client;

    public function __construct(array $config)
    {
        $this->config = $config;
        $this->client = new Client($config['service_url']);
    }

    protected function getHeaders($headers = [])
    {
        return array_merge($headers, ['X-KEY' => $this->config['KEY']]);
    }

    /**
     * @param string $uri
     * @param array  $headers
     *
     * @return Response
     */
    public function get($uri, $headers = [])
    {
        return $this->client->get($uri, $this->getHeaders($headers));
    }

    /**
     * @param string $uri
     * @param array  $data
     * @param array  $headers
     *
     * @return Response
     */
    public function post($uri, $data, $headers = [])
    {
        return $this->client->createRequest('POST', $uri, $this->getHeaders($headers), $data)->send();
    }

    public function getOffres($concession, $vin, $code)
    {
        return $this->get(sprintf("/%'.06d/vehicules/%s/produits/%s", $concession, $vin, $code));
    }

}
