<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 12/06/18
 * Time: 11:34
 */

namespace Bloom\EcranSav\Data;


class Key
{
    public $site;
    private $generateTime;
    private $print;

    public function __construct($site)
    {
        $this->site = $site;
        $this->generateTime = new \DateTime();
    }

    /**
     * @return \DateTime
     */
    public function getGenerateTime()
    {
        return $this->generateTime;
    }

    public function __sleep()
    {
        $this->print = sha1($this->site . '|' . $this->generateTime->format('c'));
    }

    public function __wakeup()
    {
        if (!$this->checkPrint()) {
            throw new \ErrorException('INVALID PRINT');
        }
    }

    private function checkPrint()
    {
        return $this->print !== sha1($this->site . '|' . $this->generateTime->format('c'));
    }
}
