<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 08/06/18
 * Time: 11:11
 */

namespace Bloom\EcranSav\Http;

use Guzzle\Http\Client;
use Guzzle\Http\Message\Response;

class Api
{
    /**
     * Our config
     * @var array
     */
    protected $config;
    /**
     * Guzzle Client to make http call
     * @var Client
     */
    protected $client;

    public function __construct(array $config)
    {
        $this->config = $config;
        $this->client = new Client($config['service_url']);
    }

    /**
     * @param string $uri
     * @param array  $headers
     *
     * @return Response
     */
    public function get($uri, $headers = [])
    {
        return $this->client->get($uri, $headers);
    }

    /**
     * @param string $uri
     * @param array  $data
     * @param array  $headers
     *
     * @return Response
     */
    public function post($uri, $data, $headers = [])
    {
        return $this->client->createRequest('POST', $uri, $headers, $data)->send();
    }

}
