<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 08/06/18
 * Time: 11:11
 */

namespace Bloom\EcranSav\Http;

use Bloom\EcranSav\Data\Offre;
use Bloom\EcranSav\Helper\KeyHelper;
use GuzzleHttp\Client;
use GuzzleHttp\RequestOptions;

class Api
{
    /**
     * Our config
     * @var array
     */
    protected $config;
    /**
     * Guzzle Client to make http call
     * @var Client
     */
    protected $client;

    public function __construct(array $config)
    {
        $this->config = $config;
        $this->client = new Client(['base_uri' => $config['service_url']]);
    }

    protected function getHeaders($headers = [])
    {
        return array_merge($headers, ['X-KEY' => KeyHelper::generate($this->config['site'])]);
    }

    protected function getUri($uri)
    {
        return (array_key_exists('base_uri', $this->config) ? $this->config['base_uri'] : '/api') . $uri;
    }

    /**
     * @param string $uri
     * @param array  $headers
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function get($uri, $headers = [])
    {
        return $this->client->get($this->getUri($uri), [RequestOptions::HEADERS => $this->getHeaders($headers)]);
    }

    /**
     * @param string $uri
     * @param array  $data
     * @param array  $headers
     *
     * @return Response
     */
    public function post($uri, $data, $headers = [])
    {
        return $this->client->post($this->getUri($uri), [RequestOptions::HEADERS => $this->getHeaders($headers), RequestOptions::BODY => $data])->send();
    }

    /**
     * @param $concession
     * @param $vin
     * @param $code
     *
     * @return Offre[]
     */
    public function getOffres($concession, $vin, $code)
    {
        $json = json_decode($this->get(sprintf("/%'.06d/vehicules/%s/produits/%s", $concession, $vin, $code))->getBody()->getContents());
        $offres = [];
        foreach ($json as $offre) {
            $f = new Offre();
            foreach ($offre as $name => $value) $f->{$name} = $value;
            $offres[] = $f;
        }

        return $offres;
    }

}
