<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 08/06/18
 * Time: 11:11
 */

namespace Bloom\EcranSav\Http;

use Bloom\EcranSav\Data\Offre;
use Bloom\EcranSav\Helper\KeyHelper;
use GuzzleHttp\Client;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\ResponseInterface;

/**
 * Class Api
 * @package Bloom\EcranSav\Http
 */
class Api
{
    /**
     * Our config
     * @var array
     */
    protected $config;
    /**
     * Guzzle Client to make http call
     * @var Client
     */
    protected $client;

    public function __construct(array $config)
    {
        $this->config = $config;
        $this->client = new Client();
    }

    protected function getHeaders($headers = [])
    {
        return array_merge($headers, ['X-KEY' => KeyHelper::generate($this->config['site'])]);
    }

    protected function getUri($uri, $division = 'auto')
    {
        $url = array_key_exists('service_url', $this->config) && array_key_exists($division, $this->config["service_url"]) ? $this->config['service_url'][$division] : '';
        $url .= (array_key_exists('base_uri', $this->config) ? $this->config["base_uri"] : '/api').$uri;
        return $url;
    }

    /**
     * @param string $uri
     * @param array  $headers
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function get($uri, $division, $headers = [])
    {
        return $this->client->get($this->getUri($uri, $division), [RequestOptions::HEADERS => $this->getHeaders($headers)]);
    }

    /**
     * @param string $uri
     * @param array  $data
     * @param array  $headers
     *
     * @return ResponseInterface
     */
    public function post($uri, $data, $headers = [])
    {
        return $this->client->post(
            $this->getUri($uri),
            [RequestOptions::HEADERS => $this->getHeaders($headers), RequestOptions::BODY => $data]
        )->send();
    }

    /**
     * @param string $concession Concession code 6 char
     * @param string $vin        Vehicule vin 17 char
     * @param string $code       Offre code
     * @param string $division   Division : auto | moto
     *
     * @return Offre[]
     */
    public function getOffres($concession, $vin, $code, $division = 'auto')
    {
        if($division == "auto"){
            $json = json_decode(
                $this->get(
                    sprintf(
                        "/%s/%'.06d/vehicules/%s/produits/%s",
                        $division,
                        $concession,
                        $vin,
                        $code
                    ),
                    $division
                )
                    ->getBody()
                    ->getContents()
            );
        } elseif($division == "moto"){
            $json = json_decode(
                $this->get(
                    sprintf(
                        "/%'.06d/vehicules/%s/produits/%s",
                        $concession,
                        $vin,
                        $code
                    ),
                    $division
                )
                    ->getBody()
                    ->getContents()
            );
        } else {
            return[];
        }

        $offres = [];
        foreach ($json as $offre) {
            $f = new Offre();
            foreach ($offre as $name => $value) $f->{$name} = $value;
            $offres[] = $f;
        }

        return $offres;
    }

}
