<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 06/08/18
 * Time: 17:49
 */

namespace Bloom\Honda\Consentement\Data;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;

class Model implements Arrayable, Jsonable
{
    public function __construct(array $attributes)
    {
        foreach ($attributes as $key => $value) {
            if (property_exists($this, $key)) {
                $this->{$key} = $value;
            }
        }
    }

    /**
     * Get the instance as an array.
     *
     * @return array
     */
    public function toArray()
    {
        static $reflexion;
        if ($reflexion === null) {
            try {
                $reflexion = new \ReflectionClass($this);
            } catch (\ReflectionException $e) {
            }
        }
        $array = [];
        foreach ($reflexion->getProperties(\ReflectionProperty::IS_PUBLIC) as $property) {
            if ($this->{$property->getName()} instanceof Arrayable) {
                $array[ $property->getName() ] = $this->{$property->getName()}->toArray();
            } else {
                $array[ $property->getName() ] = $this->{$property->getName()};
            }
        }

        return $array;
    }

    /**
     * Convert the object to its JSON representation.
     *
     * @param  int $options
     *
     * @return string
     */
    public function toJson($options = 0)
    {
        return json_encode($this->toArray(), $options);
    }
}