<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 06/08/18
 * Time: 17:31
 */

namespace Bloom\Honda\Consentement\Api;

use Bloom\Honda\Consentement\Data\Dossier;
use Bloom\Honda\Consentement\Error\UploadDossierError;

class PreferenceApi
{

    protected $config;
    protected $client;

    public function __construct($config)
    {
        $this->config = $config;
        $this->client = new \GuzzleHttp\Client(['base_uri' => $this->config['url'], 'headers' => ['x-key' => $this->config['key']]]);
    }

    /**
     * @param Dossier $dossier
     *
     * @return string Le liens d'accès au dossier nouvellement crée
     * @throws UploadDossierError
     */
    public function ouvrirDossier(Dossier $dossier)
    {
        $response = $this->client->post('/api/consent', ['json' => $dossier->toArray()]);
        if ($response->getHeader('Content-Type') === 'application/json') {
            $json = json_decode($response->getBody()->getContents(), true);
        } else {
            $json = ['error' => 'Unable to parse response'];
        }
        if ($response->getStatusCode() === 200) {
            /**
             * On ne retourne que le lien
             */
            return $json['link'];
        }
        throw new UploadDossierError();
    }
}