<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 06/08/18
 * Time: 17:36
 */

namespace Bloom\Honda\Consentement\Data;

use Bloom\Honda\Consentement\Facades\Consentement;

class Dossier extends Model
{
    /**
     * @var string Id client
     */
    public $id_client;
    /**
     * @var string String char 16
     */
    public $vin;
    /**
     * @var string Reference du dossier ouvrant le dossier de consentement
     */
    public $reference;
    /**
     * @var string Adresse du lead
     */
    public $adresse;
    /**
     * @var string Cp du lead
     */
    public $cp;
    /**
     * @var string Ville du lead
     */
    public $ville;
    /**
     * @var array Consentement receuilli pour l'adresse
     */
    public $adresse_consentement;
    /**
     * @var string Division de la concession auto|moto
     */
    public $division;
    /**
     * @var string Nom du lead
     */
    public $nom;
    /**
     * @var string Prenom du lead
     */
    public $prenom;
    /**
     * @var string Civilité du lead
     */
    public $civ;
    /**
     * @var string Char 6 code concession
     */
    public $concession_code;
    /**
     * @var Coordonnee
     */
    public $coordonnee1;
    /**
     * @var Coordonnee
     */
    public $coordonnee2;

    public function send()
    {
        return Consentement::ouvrirDossier($this);
    }

}