<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 16:01
 */

namespace Bloom\Extractor\Model;


use Bloom\Extractor\Exceptions\ExtractLeadException;
use Carbon\Carbon;

class ExtractObject
{
    const DATE_FORMAT = "d/m/Y";
    const DATETIME_FORMAT = "d/m/Y H:i";
    protected $sub_objects = [];
    protected $required = [];
    protected $datetimes = [];
    protected $dates = [];

    /**
     * @param null $datas
     * @throws \ExtractLeadException
     */
    protected function setDatas($datas = null)
    {
        foreach ($datas as $key => $value) {
            if (!in_array($key, $this->sub_objects)) {
                if (in_array($this->{$key}, $this->required) && null == $value) {
                    throw new ExtractLeadException($key . ' is required. Extract aborted');
                }

                if (in_array($key, $this->datetimes)) {
                    if ($value instanceof Carbon) {
                        $this->{$key} = $value->timezone('Europe/Paris')->format(self::DATETIME_FORMAT);
                    } else {
                        throw new ExtractLeadException("Datetime type not allowed");
                    }
                } elseif (in_array($key, $this->dates)) {
                    if ($value instanceof Carbon) {
                        $this->{$key} = $value->timezone('Europe/Paris')->format(self::DATE_FORMAT);
                    } else {
                        throw new ExtractLeadException("Date type not allowed");
                    }
                } else {
                    $this->{$key} = $value;
                }
            }
        }
        foreach($this->required as $item){
            if($this->{$item} == null){
                throw new ExtractLeadException("Il manque l\'élément ".$item);
            }
        }
    }
}