<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 15:07
 */

namespace Bloom\Extractor\Model;
use Bloom\Extractor\Interfaces\IParser;

/**
 * Class Lead
 *
 * @property string $dateFiche Must be formated like dd/MM/yyyy HH:ii
 * @property string $sousProvenance Must be SITE_JAPAUTO or HONDA_FRANCE
 * @property string $support
 * @property string $urlInscription
 * @property string $civilite
 * @property string $nom
 * @property string $prenom
 * @property string $dateNaissance
 * @property string $adress
 * @property string $complementAdress
 * @property int $codePostal
 * @property string $ville
 * @property string $pays
 * @property string $telDomicile
 * @property string $telPro
 * @property string $telPortable
 * @property string $fax
 * @property string $emailPerso
 * @property string $emailPro
 * @property string $fonction
 * @property string $nomSociete
 * @property string $siren
 * @property string $IsMotard
 * @property string $codeClient
 * @property string $leadId
 * @property string $concession
 * @property VehiculeInteret $vehiculeInteret
 * @property string $message
 * @property boolean $cnilOptin
 * @property boolean $contactEmail
 * @property boolean $contactSMS
 * @property boolean $contactTel
 * @property boolean $contactCourrier
 */
class ExtractLead extends ExtractObject
{
    const DATE_FORMAT = "dd/MM/yyyy HH:mm";
    protected $required = [];
    protected $dates = ["dateFiche", "sousProvenance"];

    const FIELDS = [
        "dateFiche",
        "sousProvenance",
        "support",
        "urlInscription",
        "civilite",
        "nom",
        "prenom",
        "dateNaissance",
        "adress",
        "complementAdress",
        "codePostal",
        "ville",
        "pays",
        "telDomicile",
        "telPro",
        "telPortable",
        "fax",
        "emailPerso",
        "emailPro",
        "fonction",
        "nomSociete",
        "siren",
        "IsMotard",
        "codeClient",
        "leadId",
        "concession",
        "vehiculeInteret",
        "message",
        "cnilOptin",
        "contactEmail",
        "contactSMS",
        "contactTel",
        "contactCourrier"
    ];

    public static function getFields(){
        return self::FIELDS;
    }

    public function __construct()
    {

    }
}