<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 16:33
 */

namespace Bloom\Extractor;

use Bloom\Extractor\Exceptions\ConfigurationError;
use Bloom\Extractor\Exceptions\ExtractLeadException;
use Bloom\Extractor\Exceptions\MalFormatedResponse;
use Bloom\Extractor\Exceptions\SendExtractedLeadException;
use Bloom\Extractor\Helpers\Helper;
use Bloom\Extractor\Interfaces\ICrmExtractable;
use Bloom\Extractor\Model\ExtractLead;
use Bloom\Extractor\Model\VehiculeInteret;

class CrmExtractor
{
    public static $lead;

    /**
     * @param ICrmExtractable $lead
     *
     * @return bool
     * @throws ExtractLeadException
     * @throws SendExtractedLeadException
     * @throws MalFormatedResponse
     * @throws ConfigurationError
     */
    public static function extract(ICrmExtractable $lead)
    {
        self::parse($lead);
        $response = self::send();
        $lead->afterExtract($response->leadCrmId);

        return true;
    }

    /**
     * @param ICrmExtractable $data
     *
     * @throws ExtractLeadException
     */
    public static function parse(ICrmExtractable $data)
    {
        try {
            self::$lead = new ExtractLead($data);
            self::$lead->vehiculeInteret = new VehiculeInteret($data);
        } catch (ExtractLeadException $e) {
            throw new ExtractLeadException("Error during lead parsing");
        }
    }

    /**
     * @return mixed
     * @throws SendExtractedLeadException
     * @throws MalFormatedResponse
     * @throws ConfigurationError
     */
    public static function send()
    {
        $conf = Helper::getConfiguration();
        if (!empty($conf->url)) {
            $ch = curl_init($conf->url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(self::$lead));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json')
            );

            $text = curl_exec($ch);
            $response = json_decode($text);

            if ($response === null) {
                throw new MalFormatedResponse(sprintf('(%s) No json response, given : %s', $conf->url, $text));
            }

            curl_close($ch);

            if ($response->code == 'OK') {
                return $response;
            }
            throw new SendExtractedLeadException($response->message);
        }
        throw new ConfigurationError('url cannot be empty');
    }

}