<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 16:33
 */

namespace Bloom\Extractor;

use Bloom\Extractor\Api\CrmApi;
use Bloom\Extractor\Interfaces\ICrmExtractable;
use Bloom\Extractor\Model\ExtractLead;
use Illuminate\Support\Facades\Facade;

/**
 * Class CrmExtractor
 * @package Bloom\Extractor
 *
 * @method static boolean extract(ICrmExtractable $data) Parse and send the ICrmExtractable to the CRM
 * @method static ExtractLead parse(ICrmExtractable $data)
 * @method static mixed send(ExtractLead $lead) Send the ExtractLead to the CRM and return the "result" body object
 * @method static void setConf(array $conf) Override the configuration array
 * @method static boolean switchCrm(string $name) Change the crm target (see the 'crm' array key to get the names)
 * @method static array getConf() Get the current configuration
 */
class CrmExtractor extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        if (defined('LARAVEL_START')) {
            // Si on est sur laravel on retourne l'instance initialisé via le ServicesProvider
            return 'CrmApi';
        }
        // si on est pas dans l'aravel il faut crée une instance static
        static $api;
        if($api === null) {
            $api = new CrmApi(require dirname(__DIR__) . '/conf/chapat_crm.php');
        }

        //Sinon on initialise à la main l'instance
        return $api;
    }
}