<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 16:01
 */

namespace Bloom\Extractor\Model;


use Bloom\Extractor\Exceptions\ExtractLeadException;
use Carbon\Carbon;
use ReflectionClass;
use ReflectionException;

trait UseSetDatas
{
    /**
     * @param array|null $datas
     *
     * @throws ExtractLeadException
     * @throws ReflectionException
     */
    protected function setDatas(array $datas = null)
    {
        $r = new ReflectionClass($this);
        if ($r->hasProperty('sub_objects')) {
            $sub_objects = $this->sub_objects;
        } else {
            $sub_objects = [];
        }
        if ($r->hasProperty('required')) {
            $required = $this->required;
        } else {
            $required = [];
        }
        if ($r->hasProperty('datetimes')) {
            $datetimes = $this->datetimes;
        } else {
            $datetimes = [];
        }
        if ($r->hasProperty('dates')) {
            $dates = $this->dates;
        } else {
            $dates = [];
        }

        // On check que tous les required sont bien la avant de continué
        foreach ($required as $item) {
            if (!array_key_exists($item, $datas) || $datas[ $item ] === null && $this->{$item} === null) {
                throw new ExtractLeadException($item . ' is required. Extract aborted');
            }
        }

        foreach ($datas as $key => $value) {
            if (!in_array($key, $sub_objects)) {
                if (in_array($this->{$key}, $required) && null == $value) {
                    throw new ExtractLeadException($key . ' is required. Extract aborted');
                }

                if (in_array($key, $datetimes) && $value != null) {
                    if ($value instanceof Carbon) {
                        $this->{$key} = $value->timezone('Europe/Paris')->format("d/m/Y H:i");
                    } else {
                        throw new ExtractLeadException("Datetime type not allowed");
                    }
                } elseif (in_array($key, $dates) && $value != null) {
                    if ($value instanceof Carbon) {
                        $this->{$key} = $value->timezone('Europe/Paris')->format("d/m/Y");
                    } else {
                        throw new ExtractLeadException("Date type not allowed");
                    }
                } else {
                    $this->{$key} = $value;
                }
            } else {
                $this->{$key} = $value;
            }
        }
    }

    /**
     * @param array $data
     *
     * @throws \Bloom\Extractor\Exceptions\ExtractLeadException
     * @throws ReflectionException
     */
    public function __construct(array $data)
    {
        $this->setDatas($data);
    }
}