<?php
/**
 * Created by IntelliJ IDEA.
 * User
 * Date
 * Time
 */

namespace Bloom\Extractor\Model;
use Bloom\Extractor\Interfaces\ICrmExtractable;

/**
 * @property string $statut
 * @property string $numMateriel
 * @property string $codeVehicle
 * @property string $codeCategory
 * @property string $category
 * @property string $codeMarque
 * @property string $marque
 * @property string $codeModele
 * @property string $modele
 * @property string $codeCarrosserie
 * @property string $carrosserie
 * @property string $codeSousModele
 * @property string $sousModele
 * @property string $codeGeneration
 * @property string $generation
 * @property string $dateDebutGeneration format: dd/MM/yyyy
 * @property string $dateFinGeneration format: dd/MM/yyyy
 * @property string $codePhase
 * @property string $phase
 * @property string $dateDebutPhase format: dd/MM/yyyy
 * @property string $dateFinPhase  format: dd/MM/yyyy
 * @property string $codeFinition
 * @property string $finition
 * @property string $cvFiscaux
 * @property string $puissanceDin
 * @property string $codeBoite
 * @property string $boite
 * @property string $codeEnergie
 * @property string $energie
 * @property string $libeleVersion
 * @property string $dateDebutVersion format: dd/MM/yyyy
 * @property string $dateFinVersion format: dd/MM/yyyy
 */

class VehiculeInteret extends ExtractObject
{

    protected $required = [
        "statut"
    ];

    protected $dates = [
        "dateDebutGeneration",
        "dateFinGeneration",
        "dateDebutPhase",
        "dateFinPhase",
        "dateDebutVersion",
        "dateDebutVersion"
    ];

    protected $statut;
    protected $numMateriel;
    protected $codeVehicle;
    protected $codeCategory;
    protected $category;
    protected $codeMarque;
    protected $marque;
    protected $codeModele;
    protected $modele;
    protected $codeCarrosserie;
    protected $carrosserie;
    protected $codeSousModele;
    protected $sousModele;
    protected $codeGeneration;
    protected $generation;
    protected $dateDebutGeneration;
    protected $dateFinGeneration;
    protected $codePhase;
    protected $phase;
    protected $dateDebutPhase;
    protected $dateFinPhase ;
    protected $codeFinition;
    protected $finition;
    protected $cvFiscaux;
    protected $puissanceDin;
    protected $codeBoite;
    protected $boite;
    protected $codeEnergie;
    protected $energie;
    protected $libeleVersion;
    protected $dateDebutVersion;
    protected $dateFinVersion;

    public function __construct(ICrmExtractable $lead){
        $this->setDatas($lead->getVehiculeInteret());
        return $this;
    }

}