<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 15:07
 */

namespace Bloom\Extractor\Model;
use Bloom\Extractor\Exceptions\ExtractLeadException;
use Bloom\Extractor\Interfaces\ICrmExtractable;

/**
 * Class Lead
 *
 * @property string $dateFiche Must be formated like dd/MM/yyyy HH:ii
 * @property string $sousProvenance Must be SITE_JAPAUTO or HONDA_FRANCE
 * @property string $support
 * @property string $urlInscription
 * @property string $civilite
 * @property string $nom
 * @property string $prenom
 * @property string $dateNaissance
 * @property string $adress
 * @property string $complementAdress
 * @property int $codePostal
 * @property string $ville
 * @property string $pays
 * @property string $telDomicile
 * @property string $telPro
 * @property string $telPortable
 * @property string $fax
 * @property string $emailPerso
 * @property string $emailPro
 * @property string $fonction
 * @property string $nomSociete
 * @property string $siren
 * @property string $IsMotard
 * @property string $codeClient
 * @property string $leadId
 * @property string $concession
 * @property VehiculeInteret $vehiculeInteret
 * @property string $message
 * @property boolean $cnilOptin
 * @property boolean $contactEmail
 * @property boolean $contactSMS
 * @property boolean $contactTel
 * @property boolean $contactCourrier
 */
class ExtractLead extends ExtractObject
{
    protected $required = ["dateFiche", "sousProvenance"];
    protected $datetimes = ["dateFiche"];
    protected $sub_objects = ["vehiculeInteret"];

    protected $dateFiche;
    protected $sousProvenance;
    protected $support;
    protected $urlInscription;
    protected $civilite;
    protected $nom;
    protected $prenom;
    protected $dateNaissance;
    protected $adress;
    protected $complementAdress;
    protected $codePostal;
    protected $ville;
    protected $pays;
    protected $telDomicile;
    protected $telPro;
    protected $telPortable;
    protected $fax;
    protected $emailPerso;
    protected $emailPro;
    protected $fonction;
    protected $nomSociete;
    protected $siren;
    protected $IsMotard;
    protected $codeClient;
    protected $leadId;
    protected $concession;
    public $vehiculeInteret;
    protected $message;
    protected $cnilOptin;
    protected $contactEmail;
    protected $contactSMS;
    protected $contactTel;
    protected $contactCourrier;

    /**
     * ExtractLead constructor.
     * Atribution des valeurs données en fonction du champs retourné par
     * @param ICrmExtractable $lead
     * @throws ExtractLeadException
     */
    public function __construct(ICrmExtractable $lead)
    {
        $this->setDatas($lead->getClient());

        return $this;
    }
}