<?php
/**
 * Created by IntelliJ IDEA.
 * User
 * Date
 * Time
 */

namespace Bloom\Extractor\Model;
use Bloom\Extractor\Interfaces\ICrmExtractable;

/**
 * @property string $statut
 * @property string $numMateriel
 * @property string $codeVehicle
 * @property string $codeCategory
 * @property string $category
 * @property string $codeMarque
 * @property string $marque
 * @property string $codeModele
 * @property string $modele
 * @property string $codeCarrosserie
 * @property string $carrosserie
 * @property string $codeSousModele
 * @property string $sousModele
 * @property string $codeGeneration
 * @property string $generation
 * @property string $dateDebutGeneration format: dd/MM/yyyy
 * @property string $dateFinGeneration format: dd/MM/yyyy
 * @property string $codePhase
 * @property string $phase
 * @property string $dateDebutPhase format: dd/MM/yyyy
 * @property string $dateFinPhase  format: dd/MM/yyyy
 * @property string $codeFinition
 * @property string $finition
 * @property string $cvFiscaux
 * @property string $puissanceDin
 * @property string $codeBoite
 * @property string $boite
 * @property string $codeEnergie
 * @property string $energie
 * @property string $libeleVersion
 * @property string $dateDebutVersion format: dd/MM/yyyy
 * @property string $dateFinVersion format: dd/MM/yyyy
 */

class VehiculeInteret extends ExtractObject
{

    protected $required = [
        "statut"
    ];

    protected $dates = [
        "dateDebutGeneration",
        "dateFinGeneration",
        "dateDebutPhase",
        "dateFinPhase",
        "dateDebutVersion",
        "dateFinVersion"
    ];

    public $statut;
    public $numMateriel;
    public $codeVehicle;
    public $codeCategory;
    public $category;
    public $codeMarque;
    public $marque;
    public $codeModele;
    public $modele;
    public $codeCarrosserie;
    public $carrosserie;
    public $codeSousModele;
    public $sousModele;
    public $codeGeneration;
    public $generation;
    public $dateDebutGeneration;
    public $dateFinGeneration;
    public $codePhase;
    public $phase;
    public $dateDebutPhase;
    public $dateFinPhase ;
    public $codeFinition;
    public $finition;
    public $cvFiscaux;
    public $puissanceDin;
    public $codeBoite;
    public $boite;
    public $codeEnergie;
    public $energie;
    public $libeleVersion;
    public $dateDebutVersion;
    public $dateFinVersion;

    public function __construct(ICrmExtractable $lead)
    {
        if($this->setDatas($lead->getVehiculeInteret() == false)){
            return false;
        }
        return $this;
    }

}