<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 16:33
 */

namespace Bloom\Extractor;

use Bloom\Extractor\Exceptions\ConfigurationError;
use Bloom\Extractor\Exceptions\ExtractLeadException;
use Bloom\Extractor\Exceptions\MalFormatedResponse;
use Bloom\Extractor\Exceptions\SendExtractedLeadException;
use Bloom\Extractor\Helpers\Helper;
use Bloom\Extractor\Interfaces\ICrmExtractable;
use Bloom\Extractor\Model\ExtractLead;
use Bloom\Extractor\Model\VehiculeInteret;
use GuzzleHttp\Client;

class CrmExtractor
{
    public static $lead;

    /**
     * @param ICrmExtractable $lead
     *
     * @return bool
     * @throws ExtractLeadException
     * @throws SendExtractedLeadException
     * @throws MalFormatedResponse
     * @throws ConfigurationError
     */
    public static function extract(ICrmExtractable $lead)
    {
        self::parse($lead);
        $response = self::send();
        $lead->afterExtract($response->leadCrmId);

        return true;
    }

    /**
     * @param ICrmExtractable $data
     *
     * @throws ExtractLeadException
     */
    public static function parse(ICrmExtractable $data)
    {
        if(class_exists('Bloom\\Honda\\Services\\Logger')){
            \Bloom\Honda\Services\Logger::create(static::class, [new \Bloom\Honda\Utils\Log\Handler\StreamHandler(LOG_PATH . '/extract/leads-export-jaa-crm.' . APP_ENV . '.log')]);
            \Bloom\Honda\Services\Logger::debug(static::class, "parsing lead", ['data' => $data, 'client' => $data->getClient(), 'vehicule' => $data->getVehiculeInteret()]);
        } else {
            \Illuminate\Support\Facades\Log::debug("parsing lead", ['data' => $data, 'client' => $data->getClient(), 'vehicule' => $data->getVehiculeInteret()]);
        }
        try {
            self::$lead = new ExtractLead($data);
            self::$lead->vehiculeInteret = new VehiculeInteret($data);
        } catch (ExtractLeadException $e) {
            throw new ExtractLeadException("Error during lead parsing");
        }
    }

    /**
     * @return mixed
     * @throws SendExtractedLeadException
     * @throws MalFormatedResponse
     * @throws ConfigurationError
     */
    public static function send()
    {
        $conf = Helper::getConfiguration();
        if (!empty($conf->url)) {
//            $ch = curl_init($conf->url);
            $data = json_encode(self::$lead);
//            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
//            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
//            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
//                    'Content-Type: application/json')
//            );
            if(class_exists('Bloom\\Honda\\Services\\Logger')){
                \Bloom\Honda\Services\Logger::debug(static::class, "Send Lead to CRM", ['lead' => $data]);
            } else {
                \Illuminate\Support\Facades\Log::debug("Send Leads to crm", ['lead' => $data]);
                \Illuminate\Support\Facades\Storage::disk()->put(\Carbon\Carbon::now()->format('YmdHisuz').'.json', $data);
            }

//            $text = curl_exec($ch);
//            $response = json_decode($text);
            $client = new Client();
            $response = $client->request("POST", $conf->url, [
                'json' => $data
            ]);

            if ($response === null) {
                throw new MalFormatedResponse(sprintf('(%s) No json response, given : %s', $conf->url, $text));
            }

//            curl_close($ch);

            if ($response->code == 'OK') {
                return $response;
            }
            throw new SendExtractedLeadException($response->message);
        }
        throw new ConfigurationError('url cannot be empty');
    }

}