<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 16:33
 */

namespace Bloom\Extractor;

use Bloom\Extractor\Exceptions\ExtractLeadException;
use Bloom\Extractor\Exceptions\SendExtractedLeadException;
use Bloom\Extractor\Helpers\Helper;
use Bloom\Extractor\Interfaces\ICrmExtractable;
use Bloom\Extractor\Model\ExtractLead;
use Bloom\Extractor\Model\VehiculeInteret;

class CrmExtractor
{
    public static $lead;

    public static function extract(ICrmExtractable $lead)
    {
        try {
            self::parse($lead);
            $response = self::send();
            $lead->afterExtract($response->leadCrmId);
            return true;
        } catch (ExtractLeadException $e) {
            throw new ExtractLeadException($e->getMessage());
        } catch(SendExtractedLeadException $e){
            throw new SendExtractedLeadException($e->getMessage());
        } catch (\Exception $e){
            throw new \Exception($e->getMessage());
        }
    }

    public static function parse(ICrmExtractable $data)
    {
        try {
            self::$lead = new ExtractLead($data);
            self::$lead->vehiculeInteret = new VehiculeInteret($data);
        } catch (ExtractLeadException $e) {
            throw new ExtractLeadException("Error during lead parsing");
        } catch(\Exception $e){
            throw new \Exception($e->getMessage());
        }

    }

    public static function send()
    {
        try {
            $conf = Helper::getConfiguration();
            if (!empty($conf->url)) {
                $ch = curl_init($conf->url);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(self::$lead));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json')
                );

                $response = json_decode(curl_exec($ch));

                curl_close($ch);

                if ($response->code == 'OK') {
                    return $response;
                }
            }
            throw new SendExtractedLeadException($response->message);
        } catch (SendExtractedLeadException $e){
            throw new SendExtractedLeadException($response->message);
        } catch(\Exception $e){
            throw new \Exception($e->getMessage());
        }
    }

}