<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 06/11/19
 * Time: 15:52
 */

namespace Bloom\Extractor\Logger;

use Bloom\Honda\Services\Logger;
use Bloom\Honda\Utils\Log\Handler\StreamHandler;

/**
 * Class Log
 * @package Bloom\Extractor\Logger
 *
 * @method static void emergency(string $message, array $context = [])
 * @method static void alert(string $message, array $context = [])
 * @method static void critical(string $message, array $context = [])
 * @method static void error(string $message, array $context = [])
 * @method static void warning(string $message, array $context = [])
 * @method static void notice(string $message, array $context = [])
 * @method static void info(string $message, array $context = [])
 * @method static void debug(string $message, array $context = [])
 * @method static void log($level, string $message, array $context = [])
 * @method static mixed channel(string $channel = null)
 */
class Log
{
    static public $logs = [];

    public static function __callStatic($name, $arguments)
    {
        if (env('APP_ENV') === 'testing') {
            return static::$logs[ $name ][] = $arguments;
        }
        if (!defined('LARAVEL_START')) {
            // Environnement Services-honda
            if (!Logger::channelExist('CRM-CHAPAT')) {
                Logger::create('CRM-CHAPAT', [new StreamHandler(LOG_PATH . '/extract/leads-export-jaa-crm.' . APP_ENV . '.log')]);
            }
            $args = ['CRM-CHAPAT'];

            return call_user_func_array([Logger::class, $name], array_values(array_merge($args, $arguments)));
        } else {
            return call_user_func_array([\Illuminate\Support\Facades\Log::class, $name], array_values($arguments));
        }
    }
}