<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 15:07
 */

namespace Bloom\Extractor\Model;
use Bloom\Extractor\Exceptions\ExtractLeadException;
use Bloom\Extractor\Interfaces\ICrmExtractable;

/**
 * Class Lead
 *
 * @property string $dateFiche Must be formated like dd/MM/yyyy HH:ii
 * @property string $sousProvenance Must be SITE_JAPAUTO or HONDA_FRANCE
 * @property string $support
 * @property string $urlInscription
 * @property string $civilite
 * @property string $nom
 * @property string $prenom
 * @property string $dateNaissance
 * @property string $address
 * @property string $complementAddress
 * @property int $codePostal
 * @property string $ville
 * @property string $pays
 * @property string $telDomicile
 * @property string $telPro
 * @property string $telPortable
 * @property string $fax
 * @property string $emailPerso
 * @property string $emailPro
 * @property string $fonction
 * @property string $nomSociete
 * @property string $siren
 * @property string $isMotard
 * @property string $codeClient
 * @property string $leadId
 * @property string $concession
 * @property VehiculeInteret $vehiculeInteret
 * @property VehiculeReprise $vehiculeReprise
 * @property string $message
 * @property boolean $cnilOptin
 * @property boolean $contactEmail
 * @property boolean $contactSMS
 * @property boolean $contactTel
 * @property boolean $contactCourrier
 * @property string $parcVehicules
 */
class ExtractLead extends ExtractObject
{
    protected $required = ["dateFiche", "sousProvenance"];
    protected $datetimes = ["dateFiche"];
    protected $sub_objects = ["vehiculeInteret", "vehiculeReprise"];

    public $dateFiche;
    public $sousProvenance;
    public $support;
    public $urlInscription;
    public $civilite;
    public $nom;
    public $prenom;
    public $dateNaissance;
    public $address;
    public $complementAddress;
    public $codePostal;
    public $ville;
    public $pays;
    public $telDomicile;
    public $telPro;
    public $telPortable;
    public $fax;
    public $emailPerso;
    public $emailPro;
    public $fonction;
    public $nomSociete;
    public $siren;
    public $isMotard;
    public $codeClient;
    public $leadId;
    public $concession;
    public $vehiculeInteret;
    public $vehiculeReprise;
//    public $parcVehicules;
    public $message;
    public $cnilOptin;
    public $contactEmail;
    public $contactSMS;
    public $contactTel;
    public $contactCourrier;

    /**
     * ExtractLead constructor.
     * Atribution des valeurs données en fonction du champs retourné par
     * @param ICrmExtractable $lead
     * @throws ExtractLeadException
     */
    public function __construct(ICrmExtractable $lead)
    {
        $this->setDatas($lead->getClient());

        return $this;
    }
}