<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 07/06/2018
 * Time: 12:46
 */

namespace Bloom\Extractor\Helpers;

use Symfony\Component\Yaml\Yaml;

class Helper
{
    public static function defineEnv(){
        if (!defined('APP_ENV')) {
            $env = array_key_exists('APP_ENV', $_SERVER) ? $_SERVER['APP_ENV'] : 'development';
            $env = ($env == "prod") ? "production" : $env;
            define('APP_ENV', $env);
            $_SERVER['APP_ENV'] = APP_ENV;
        }
    }

    public static function getConfiguration(){
        self::defineEnv();
        return (object)Yaml::parse(file_get_contents(__DIR__.'/../conf/'.APP_ENV.'.yml'));
    }
}