<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 16:01
 */

namespace Bloom\Extractor\Model;


use Carbon\Carbon;

class ExtractObject
{
    const DATE_FORMAT = "dd/MM/yyyy HH:mm";
    protected $sub_objects = [];
    protected $required = [];
    protected $dates = [];

    /**
     * @param null $datas
     * @throws \ExtractLeadException
     */
    protected function setDatas($datas = null){
        foreach($datas as $key => $value){
            if(!in_array($key, $this->sub_objects)){
                if(in_array($this->{$key}, $this->required) && null == $value) {
                    throw new \ExtractLeadException($key.' is required. Extract aborted');
                }

                if(in_array($key, $this->dates)){
                    if($value instanceof Carbon){
                        $this->{$key} = $value->format(ExtractLead::DATE_FORMAT);
                    } else {
                        throw new \ExtractLeadException("Date type not allowed");
                    }
                }
            }
        }
    }
}