<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 15:30
 */


namespace Bloom\Extractor\Interfaces;


use Bloom\Extractor\Model\ExtractLead;
use Bloom\Extractor\Model\VehiculeInteret;

interface ICrmExtractable
{
    const SOUS_PROVENANCES = ["SITE_JAPAUTO", "HONDA_FRANCE"];

    const STATUTS = ["VN", "VO"];

    /**
     * Récupère un lead extractacle pour le CRM
     * La fonction peut être nulle si on accède aux données depuis la classe
     * Appelle la fonction getProvenance()
     *
     * @param mixed|null $datas
     * @return ExtractLead
     */
    public function getClient($datas = null);

    /**
     * Récupère les données métiers propres aux véhicules.
     * Appelle l fonction getStatus()
     *
     * @param mixed|null $datas
     * @return VehiculeInteret
     */
    public function getVehiculeInteret($datas = null);

    /**
     * Donne le type de provenance à la fonction getClient()
     * Doit correspondre à l'un des éléments de la constante SOUS_PROVENANCES
     *
     * @return string
     */
    public function getProvenance();

    /**
     * Donne le type de provenance à la fonction getVehiculeInteret()
     * Doit correspondre à l'un des éléments de la constante STATUTS
     *
     * @return string
     */
    public function getStatus();
}