<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïs
 * Date: 06/06/2018
 * Time: 16:33
 */

namespace Bloom\Extractor;

use Bloom\Extractor\Exceptions\ExtractLeadException;
use Bloom\Extractor\Exceptions\SendExtractedLeadException;
use Bloom\Extractor\Helpers\Helper;
use Bloom\Extractor\Interfaces\ICrmExtractable;
use Bloom\Extractor\Model\ExtractLead;
use Bloom\Extractor\Model\VehiculeInteret;

class CrmExtractor
{
    private static $lead;

    public static function extract(ICrmExtractable $lead)
    {
        try {
            self::parse($lead);
            self::send();
        } catch (ExtractLeadException $e) {
            throw new ExtractLeadException($e->getMessage());
        } catch(SendExtractedLeadException $e){
            throw new SendExtractedLeadException($e->getMessage());
        } catch (\Exception $e){
            throw new \Exception($e->getMessage());
        }
    }

    private static function parse(ICrmExtractable $data)
    {
        try {
            self::$lead = new ExtractLead($data);
            self::$lead->vehiculeInteret = new VehiculeInteret($data);
        } catch (ExtractLeadException $e) {
            throw new ExtractLeadException("Error during lead parsing");
        }

    }

    public static function send()
    {
        try {
            $conf = Helper::getConfiguration();
            self::$lead = json_encode([
                "dateFiche" => "04/06/2018 17:16",
                "sousProvenance" => "SITE_JAPAUTO",
                "leadId" => "55",
                "civilite" => "Monsieur",
                "nom" => "Da Silva",
                "prenom" => "François",
                "codePostal" => "33620",
                "ville" => "Tizac de lapouyade",
                "telPortable" => "0781822953",
                "emailPerso" => "mjj02@live.fr",
                "vehiculeInteret" => [
                    "statut" => "VN",
                    "modele" => "CR-V",
                    "generation" => "IV",
                    "phase" => "Ph2",
                    "marque" => "Honda"
                ],
                "urlInscription" => "https:\/\/www.japautoauto.com\/honda-cr-v-16-i-dtec-elegance-380"
            ]);
            if (!empty($conf->url)) {
                $ch = curl_init($conf->url);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, self::$lead);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json')
                );

                $response = json_decode(curl_exec($ch));

                curl_close($ch);

                if ($response->code == 'OK') {
                    return $response;
                }
            }
            throw new SendExtractedLeadException($response->message);
        } catch (SendExtractedLeadException $e){
            throw new SendExtractedLeadException($response->message);
        } catch(\Exception $e){
            throw new \Exception($e->getMessage());
        }
    }

}