<?php

namespace Bloom\Cms\UserModule;

use Bloom\CMS\Modules\Architecture\Model\AdminMenu;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Bloom\Cms\UserModule\{Commands\Admin, Commands\InitProject, Data\Autorisation, Data\User};
use Illuminate\Foundation\AliasLoader;
use Illuminate\Support\{Facades\DB, Facades\Gate, Facades\Log, Facades\Schema};
use Illuminate\Support\ServiceProvider;


class CmsUserModuleProvider extends ServiceProvider
{
    const USERS_LIST = 'USERS_LIST';
    const USERS_EDIT = 'USERS_EDIT';
    const USERS_DELETE = 'USERS_DELETE';
    const USERS_CREATE = 'USERS_CREATE';
    const USERS_G_EDIT = 'USERS_G_EDIT';
    const USERS_G_DELETE = 'USERS_G_DELETE';
    const USERS_G_LIST = 'USERS_G_LIST';

    /**
     * Register services.
     *
     */
    public function register()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([InitProject::class, Admin::class]);
        }
        $this->loadViewsFrom(dirname(__DIR__) . '/ressources/views', 'UserModule');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadTranslationsFrom(dirname(__DIR__) . '/ressources/lang', 'courier');

        $this->publishes([
            dirname(__DIR__) . '/public' => public_path('vendor/cms-authentification'),
        ], 'assets');

        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');

        $dirname = dirname(__DIR__) . '/routes';
        foreach (scandir($dirname) as $route) {
            if (!in_array($route, ['.', '..'])) {
                $this->loadRoutesFrom($dirname . '/' . $route);
            }
        }
    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('user')->firstOrCreate([
                'nom'        => 'user',
                'nom_public' => 'Utilisateurs',
                'route'      => 'admin_user_list',
            ]);
            if (!$module->exists) {
                $module->active = 1;
                $module->save();
            }
            AdminMenu::firstOrCreate([
                'module_id' => $module->id,
                'label'     => 'Utilisateurs',
                'route'     => 'admin_user_list',
                'active'    => 1,
            ]);
            AdminMenu::firstOrCreate([
                'module_id' => $module->id,
                'label'     => 'Groupes',
                'route'     => 'admin_group_list',
                'active'    => 1,
            ]);
            AdminMenu::firstOrCreate([
                'module_id' => $module->id,
                'label'     => 'Autorisations',
                'route'     => 'admin_authorization_list',
                'active'    => 1,
            ]);

            return $module;
        }

        return false;
    }

    /**
     * Bootstrap services.
     * @return void
     */
    public function boot()
    {

        $loader = AliasLoader::getInstance();
        $loader->alias('App\User', 'Bloom\Cms\UserModule\Data\User');
        $loader->alias('App\Http\Controllers\Auth\ForgotPasswordController', 'Bloom\Cms\UserModule\Http\Controllers\Auth\ForgotPasswordController');
        $loader->alias('App\Http\Controllers\Auth\ResetPasswordController', 'Bloom\Cms\UserModule\Http\Controllers\Auth\ResetPasswordController');
        config(["mail.from" => "ne-pas-repondre@notification.honda.fr"]);
        config(["mail.name" => "Honda"]);
        self::getModule();
        if (Schema::hasTable('autorisations')) {
            foreach (Autorisation::all() as $auth) {
                Log::debug("Gate", ['auth' => $auth]);
                if (!Gate::allows($auth->code)) {
                    Gate::define($auth->code, function (User $user) use ($auth) {
                        foreach ($user->groupes as $groupe_id) {
                            if (DB::table('groupe_autorisations')
                                    ->where('groupes_id', $groupe_id->pivot->groupes_id)
                                    ->where('autorisations_id', $auth->id)
                                    ->count() > 0)
                                return true;
                        }

                        return false;
                    });
                }
            }
        }
    }
}
