<?php
/**
 * Created by : loic
 * Created at : 14/04/2020
 *
 * In : IntelliJ IDEA
 */

use Illuminate\Support\Facades\Route;

Route::group([
    'middleware' => ['web', 'auth'],
    'prefix'     => config('app.admin'),
    'namespace'  => '\Bloom\Cms\UserModule\Http\Controllers'],
    function () {
        Route::group(['prefix' => 'user'], function () {
            Route::get('/list', 'UtilisateursController@listeUtilisateur')->name('admin_user_list');
            Route::post('/{user}/edit/save', 'UtilisateursController@editUtilisateurSave')->name('admin_user_edit_save');
            Route::get('/{user}/edit', 'UtilisateursController@editUtilisateur')->name('admin_user_edit');
            Route::get('/{user}/delete', 'UtilisateursController@deleteUser')->name('admin_user_delete');
            Route::get('/new', 'UtilisateursController@nouvelUtilisateur')->name('admin_user_new');
            Route::post('/new/save', 'UtilisateursController@nouvelUtilisateurSave')->name('admin_user_new_save');
        });
        Route::group(['prefix' => 'authorization'], function () {
            Route::get('/list', 'AutorisationController@listeAutorisation')->name('admin_authorization_list');
        });

        Route::group(['prefix' => 'group'], function () {
            Route::get('/list', 'GroupeController@listeGroupe')->name('admin_group_list');
            Route::post('/new/save', 'GroupeController@nouveauGroupeSave')->name('admin_group_new_save');
            Route::get('/new', 'GroupeController@nouveauGroupe')->name('admin_group_new');
            Route::get('/{groupe}/edit', 'GroupeController@editGroupe')->name('admin_group_edit');
            Route::post('/{groupe}/edit/save', 'GroupeController@editGroupeSave')->name('admin_group_edit_save');
            Route::get('/{groupes}/delete', 'GroupeController@deleteGroupe')->name('admin_group_delete');
        });
        Route::group(['prefix' => 'modal'], function () {
            Route::get('/{user}/users', 'ModalController@getModalUser')->name('admin_user_modal_get');
            Route::get('/{groupes}/groupe', 'ModalController@getModalGroupe')->name('admin_group_modal_get');
            Route::get('/{autorisations}/autorisation', 'ModalController@getModalAutorisation')->name('admin_authorization_modal_get');
        });
    }
);
