<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGroupeAutorisationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('groupe_autorisations', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('groupes_id',false,true);
            $table->integer('autorisations_id',false,true);
            $table->timestamps();
            $table->foreign(['groupes_id'])->references('id')->on('groupes')->onDelete('cascade');
            $table->foreign(['autorisations_id'])->references('id')->on('autorisations')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('groupe_autorisations');
    }
}
